function JTabFolder(owner, parent, name, tabs, activetab, rect, parentTab)
{
	var self = this,
		_disposed = false,
		_isRightMost = true,
		_isBottomMost = true;

	this.initialize(owner, parent, name, null, null, rect, null, null, null, parentTab);

	this.tabs = new Array();

	if (tabs != null)
	{
		var pairs = tabs.split(scItemSep);
		var parts = "";
		pairs.forEach (function (pair)
		{
			parts = pair.split(scEquals);
			this.tabs[parts[0]] = parts[1];
			this.tabs.length++;
		}, self);
	}

	this.active   = activetab;
	this.rect     = new JRect(rect);
	this.methods  = (cmRender | cmLoad | cmSave);

	this.render = render;
	this.load   = load;
	this.getTabControls = getTabControls;
	this.save   = save;
	this.select = select;
	this.dispose = dispose;

	this.onresize = new JEvent();

	function render(fs)
	{
	  self.rect.height -= tfTabHeight;
	
	  fs.append('<div class="tabfolder" id="' + self.name + '">');
	  fs.append('<table cellpadding="0" cellspacing="1" border="0" height="' + tfTabHeight + '"px" style="position: relative;">');
	  fs.append('<tr>');
	
	  self.tabs.forIn( function (item, tab)
	  {
	    fs.append('<td class="tab" id="' + self.name + '_' + tab + '_tab" style="font-weight: ' + (tab == self.active ? "bold" : "normal") + '" >' + item + '</td>');
	  }, self);
	
	  fs.append('</tr>');
	  fs.append('</table>');
	
	  self.tabs.forIn( function (item, tab)
	  {
//	    fs.append('<div class="folder" id="' + self.name + '_' + tab + '_folder" style="left: 0; top: ' + tfTabHeight + '; ' + (tab == self.active ? '' : '; display: none') + '">');
	    fs.append('<div class="folder" id="' + self.name + '_' + tab + '_folder" style="left: 0; top: 0; height: ' + self.rect.height + ';">');

	    self.controls.forEach( function (control)
	    {
	      if ((control.tab == tab) && (utils.inSet(cmRender, control.methods)))
	        fs.append(control.render(fs));
	    }, self);

	    fs.append("</div>");

	  }, self);

	  fs.append("</div>");

	  self.rect.height += tfTabHeight;
	}

	function load()
	{
		var style = self.$$().style;
		style.top = self.rect.top;
		style.left = self.rect.left;

		var pos = self.checkPosition();
		_isRightMost = pos.isRightMost;
		_isBottomMost = pos.isBottomMost;

		_setSize();

		self.controls.forEach( function (control)
		{
			if (utils.inSet(cmLoad, control.methods))
				control.load();
		}, self);

		self.tabs.forIn( function (item, tab)
		{
			var elem = self.$$('_' + tab + '_tab')

			if (tab != self.active)
			{
				var fld = self.$$('_' + tab + '_folder');
				fld.style.display = 'none';
			}
			elem.onclick = getClickFunc(tab);
		}, self);

//		_setSize();
		if (self.getParentObject().onresize != null)
			self.getParentObject().onresize.attach(_setSize);
		else
			self.getForm().onresize.attach(_setSize);
	}

	function getClickFunc(tab)
	{
		return function() { self.select(tab); };
	}

	function _setSize()
	{
		var style = self.$$().style;
		var w, h;

		if (_isRightMost)
		{
			var maxRight = self.getRightMostChildControlPos();
			w = (browser.isIE) ? parseInt(self.$$().parentNode.style.width) : self.$$().parentNode.clientWidth;
			if ((isNaN(w)) || (w == 0))
				w = self.$$().parentNode.clientWidth;
			w = w - self.rect.left - 10;
			if (maxRight > w)
				w = maxRight + 6;
			if (w < 10)
				w = 10;
			style.width = w;
		}
		else
		{
			style.width = self.rect.width;
			style.position = 'absolute';
		}

		if (_isBottomMost)
		{
			var maxBottom = self.getBottomMostChildControlPos();
			h = (browser.isIE) ? parseInt(self.$$().parentNode.style.height) : self.$$().parentNode.clientHeight;
			if ((isNaN(h)) || (h == 0))
				h = self.$$().parentNode.clientHeight;
			h = h - self.rect.top - 25;
			if (maxBottom > h)
				h = maxBottom + 15;
			if (h < 10)
				h = 10;
			style.height = h;
		}
		else
		{
			style.height = self.rect.height;
			style.position = 'absolute';
		}

		if ((_isRightMost) || (_isBottomMost))
		{
			self.tabs.forIn( function (item, tab)
			{
				var fld = self.$$('_' + tab + '_folder');
				if (_isBottomMost)
					fld.style.height = h - 8;
				if (_isRightMost)
					fld.style.width  = w;
			}, self);
		}

		self.onresize.raise();
	}

	function getTabControls(tab)
	{
		var ctrls = [];

	    self.controls.forEach( function (control)
	    {
	      if (control.tab == tab)
	        ctrls.push(control);
	    }, self);

	    return ctrls;
	}

	function save()
	{
	  self.controls.forEach( function (control)
	  {
	    if (utils.inSet(cmSave, control.methods))
	      control.save();
	  }, self);
	}

	function select(tab)
	{
	  self.$$('_' + self.active + '_tab').style.fontWeight = 'normal';
	  self.$$('_' + self.active + '_folder').style.display = 'none';

	  self.$$('_' + tab + '_tab').style.fontWeight         = 'bold';
	  self.$$('_' + tab + '_folder').style.display         = 'block';
	  self.active = tab;
	}

	function dispose()
	{
		if (_disposed)
			return;

		self.tabs.forIn( function (item, tab)
		{
			var elem = self.$$('_' + tab + '_tab')
			if (elem != null)
				elem.onclick = null;
		}, self);

		this.onresize.dispose();
		self.disposeChildren();

		self.base.dispose.call(self);
		_disposed = true;
	}

}

JTabFolder.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();
